<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('footer_settings', function (Blueprint $table) {
            if (!Schema::hasColumn('footer_settings', 'contact_address')) {
                $table->text('contact_address')->nullable()->after('contact_email');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('footer_settings', function (Blueprint $table) {
            if (Schema::hasColumn('footer_settings', 'contact_address')) {
                $table->dropColumn('contact_address');
            }
        });
    }
};
