<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php
        $headerSetting = \App\Models\HeaderSetting::first();
        $siteTitle = $headerSetting?->site_name ?? 'Barishal Cantonment Public School & College';
    ?>
    <title><?php echo $__env->yieldContent('title', $siteTitle); ?></title>

    <!-- Dynamic Favicon -->
    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($headerSetting): ?>
        <link rel="icon" type="image/png" href="<?php echo e($headerSetting->favicon ?? asset('images/logo.png')); ?>">
    <?php else: ?>
        <link rel="icon" href="<?php echo e(asset('images/logo.png')); ?>">
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

    <!-- Performance Optimization: Preconnect to CDNs -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link rel="preconnect" href="https://cdn.jsdelivr.net">
    <link rel="preconnect" href="https://cdnjs.cloudflare.com">

    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- FontAwesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <!-- Google Fonts for Bengali Support -->
    <link
        href="https://fonts.googleapis.com/css2?family=Noto+Sans+Bengali:wght@400;700&family=Hind+Siliguri:wght@400;700&display=swap"
        rel="stylesheet">

    <!-- Vite Assets -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    <!-- Popup Modal CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('css/popup-modal.css')); ?>">

    <!-- Dynamic Theme Colors -->
    <?php
        $theme = \App\Models\ThemeSetting::first();
    ?>
    <style>
        :root {
            --primary-color:
                <?php echo e($theme->primary_color ?? '#006a4e'); ?>

            ;
            --secondary-color:
                <?php echo e($theme->secondary_color ?? '#f42a41'); ?>

            ;
            --accent-color:
                <?php echo e($theme->accent_color ?? '#f8f9fa'); ?>

            ;
            --text-color:
                <?php echo e($theme->text_color ?? '#333333'); ?>

            ;
            --link-color:
                <?php echo e($theme->link_color ?? '#006a4e'); ?>

            ;
            --topbar-bg-color:
                <?php echo e($theme->topbar_bg_color ?? '#5a9a7a'); ?>

            ;
            --header-bg-color:
                <?php echo e($theme->header_bg_color ?? '#2d6a4f'); ?>

            ;
            --navbar-bg-color:
                <?php echo e($theme->navbar_bg_color ?? '#1e5540'); ?>

            ;
            --navbar-hover-color:
                <?php echo e($theme->navbar_hover_color ?? 'rgba(255,255,255,0.15)'); ?>

            ;
            --footer-bg-color:
                <?php echo e($theme->footer_bg_color ?? '#2c3e50'); ?>

            ;
            --footer-bottom-bg-color:
                <?php echo e($theme->footer_bottom_bg_color ?? '#1a252f'); ?>

            ;
            --body-bg-color:
                <?php echo e($theme->body_bg_color ?? '#f4f6f9'); ?>

            ;
            --ticker-bg-color:
                <?php echo e($theme->ticker_bg_color ?? '#006a4e'); ?>

            ;
            --ticker-text-color:
                <?php echo e($theme->ticker_text_color ?? '#ffffff'); ?>

            ;
        }

        body {
            font-family: 'Noto Sans Bengali', 'Hind Siliguri', 'Arial', sans-serif;
            background-color: var(--body-bg-color);
            color: var(--text-color);
            overflow-x: hidden;
        }

        html {
            overflow-x: hidden;
        }

        img {
            max-width: 100%;
            height: auto;
        }

        a {
            color: var(--link-color);
            transition: all 0.3s ease;
        }

        a:hover {
            transform: translateX(3px);
        }

        .bg-primary-custom {
            background-color: var(--primary-color) !important;
            color: white;
        }

        .text-primary-custom {
            color: var(--primary-color) !important;
        }

        .top-bar {
            background-color: var(--topbar-bg-color);
            font-size: 0.85rem;
            padding: 8px 0;
            color: white;
        }

        .top-bar a {
            color: white !important;
            text-decoration: none;
        }

        .main-header {
            background: var(--header-bg-color) !important;
            padding: 30px 0 !important;
            border-bottom: none !important;
        }

        .navbar-custom {
            background-color: var(--navbar-bg-color) !important;
            padding: 0.5rem 0 !important;
            min-height: 60px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
            z-index: 1000;
        }

        .navbar-custom .navbar-nav {
            flex-wrap: wrap;
        }

        .navbar-custom .nav-link {
            color: white !important;
            font-weight: 500;
            font-size: 0.9rem;
            padding: 8px 14px !important;
            border-right: 1px solid rgba(255, 255, 255, 0.1);
            transition: all 0.3s ease;
            position: relative;
        }

        .navbar-custom .nav-link::before {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            width: 0;
            height: 100%;
            background: linear-gradient(to right, var(--navbar-hover-color), transparent);
            transition: width 0.3s ease;
            z-index: -1;
        }

        .navbar-custom .nav-link:hover::before {
            width: 100%;
        }

        .navbar-custom .nav-link:hover,
        .navbar-custom .nav-link:focus {
            background-color: transparent !important;
            color: #ffffff !important;
            font-weight: 600;
        }

        .navbar-custom .dropdown-menu {
            background-color: var(--navbar-bg-color);
            border: none;
            border-radius: 0 0 8px 8px;
            box-shadow: 0 8px 16px rgba(0, 0, 0, 0.2);
            animation: slideDown 0.3s ease;
            margin-top: 0;
            border-top: 3px solid var(--secondary-color);
        }

        @keyframes slideDown {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .navbar-custom .dropdown-item {
            color: white !important;
            font-size: 0.85rem;
            padding: 8px 18px;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }

        .navbar-custom .dropdown-item::before {
            content: '';
            position: absolute;
            left: 0;
            top: 0;
            height: 100%;
            width: 4px;
            background: linear-gradient(to bottom, var(--secondary-color), var(--primary-color));
            transform: scaleY(0);
            transition: transform 0.3s ease;
        }

        .navbar-custom .dropdown-item:hover {
            background: linear-gradient(to right, rgba(255, 255, 255, 0.1), transparent) !important;
            padding-left: 23px;
            color: #ffffff !important;
            font-weight: 600;
        }

        .navbar-custom .dropdown-item:hover::before {
            transform: scaleY(1);
        }

        /* Message Card Image Alignment Fix */
        .message-card-img-container {
            display: flex;
            justify-content: center;
            align-items: center;
            margin-bottom: 1.5rem;
            width: 100%;
        }

        .message-card-img {
            width: 200px;
            height: 250px;
            object-fit: cover;
            border-radius: 12px;
            border: 3px solid white;
            box-shadow: 0 12px 35px rgba(0, 0, 0, 0.6);
            transition: all 0.3s ease;
        }

        .message-card-img:hover {
            transform: scale(1.05);
        }

        /* Slider Image Height and Fit Fix */
        .slider-img {
            height: 550px;
            object-fit: cover;
            object-position: center top;
            transition: all 0.3s ease;
        }

        @media (max-width: 768px) {
            .slider-img {
                height: 250px;
            }
        }

        /* Hover Dropdown - Show on hover instead of click */
        .navbar-custom .nav-item.dropdown:hover .dropdown-menu {
            display: block;
            animation: slideDown 0.3s ease;
        }

        .navbar-custom .dropdown-menu {
            display: none;
            transition: all 0.3s ease;
        }

        .navbar-custom .dropdown-menu.show {
            display: block;
        }

        /* Mobile Toggle Button - White Color */
        .navbar-toggler {
            border-color: rgba(255, 255, 255, 0.5) !important;
            padding: 0.25rem 0.5rem;
        }

        .navbar-toggler:focus {
            box-shadow: 0 0 0 0.25rem rgba(255, 255, 255, 0.25);
        }

        .navbar-toggler-icon {
            background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 30 30'%3e%3cpath stroke='rgba(255, 255, 255, 1)' stroke-linecap='round' stroke-miterlimit='10' stroke-width='2' d='M4 7h22M4 15h22M4 23h22'/%3e%3c/svg%3e") !important;
        }

        .footer {
            background-color: var(--footer-bg-color);
            color: white;
            padding: 40px 0 0;
        }

        .footer-bottom {
            background-color: var(--footer-bottom-bg-color);
            padding: 15px 0;
        }

        /* Smooth Scrolling */
        html {
            scroll-behavior: smooth;
        }

        /* Card Hover Effects */
        .card {
            transition: all 0.3s ease;
        }

        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.15) !important;
        }

        /* Button Hover Effects */
        .btn {
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }

        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
        }

        .btn::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 0;
            height: 0;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.3);
            transform: translate(-50%, -50%);
            transition: width 0.6s, height 0.6s;
        }

        .btn:hover::before {
            width: 300px;
            height: 300px;
        }

        /* Fade In Animation */
        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(20px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .fade-in {
            animation: fadeIn 0.6s ease;
        }

        /* Carousel Caption Animation */
        .carousel-caption {
            animation: fadeIn 0.8s ease;
        }

        /* News Ticker Animation */
        @keyframes tickerScroll {
            0% {
                transform: translateX(0);
            }

            100% {
                transform: translateX(-50%);
            }
        }

        /* Mobile Responsiveness */
        @media (max-width: 768px) {
            .main-header {
                padding: 10px 0 !important;
                text-align: center;
            }

            .main-header h3 {
                font-size: 1.2rem !important;
                margin-bottom: 2px !important;
            }

            .main-header h5 {
                font-size: 1rem !important;
                margin-bottom: 2px !important;
            }

            .main-header p {
                font-size: 0.8rem !important;
            }

            .main-header img {
                max-height: 60px !important;
                margin-bottom: 5px;
            }

            .main-header .col-md-8 {
                text-align: center !important;
            }

            /* Navbar */
            .navbar-custom .navbar-nav {
                padding: 10px;
            }

            .navbar-custom .nav-link {
                border-right: none;
                border-bottom: 1px solid rgba(255, 255, 255, 0.1);
                padding: 10px !important;
            }

            .navbar-custom .dropdown-menu {
                border: none;
                background-color: rgba(0, 0, 0, 0.1);
                box-shadow: none;
                padding-left: 20px;
            }

            /* Smooth Mobile Collapse */
            .navbar-collapse {
                transition: height 0.4s ease-in-out;
            }

            .navbar-collapse.show {
                border-top: 1px solid rgba(255, 255, 255, 0.1);
                margin-top: 10px;
            }

            /* Slider */
            #heroCarousel .carousel-item img {
                height: auto !important;
                min-height: 200px;
                object-fit: cover !important;
            }

            /* Sidebar */
            .col-lg-3 {
                margin-top: 2rem;
            }

            /* Prevent horizontal scroll */
            .row {
                margin-left: 0 !important;
                margin-right: 0 !important;
            }

            .container {
                padding-left: 15px !important;
                padding-right: 15px !important;
            }

            .main-header .row {
                margin-left: 0 !important;
                margin-right: 0 !important;
            }

            .main-header h3,
            .main-header h5 {
                word-wrap: break-word;
                overflow-wrap: break-word;
            }
        }
    </style>
    <?php echo $__env->yieldPushContent('styles'); ?>
</head>

<body>

    <?php
        // Get the current homepage template setting
        $currentTemplate = \App\Models\ThemeSetting::first()->homepage_template ?? 'template_1';
    ?>

    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($currentTemplate === 'template_1'): ?>
        <?php echo $__env->make('partials.header-template1', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php elseif($currentTemplate === 'template_2'): ?>
        <?php echo $__env->make('partials.header-template2', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php elseif($currentTemplate === 'template_3'): ?>
        <?php echo $__env->make('partials.header-template3', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php else: ?>
        <?php echo $__env->make('partials.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

    <main>
        <?php echo $__env->yieldContent('content'); ?>
    </main>

    <?php echo $__env->make('partials.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <!-- Bootstrap 5 JS Bundle -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

    <!-- Hover Dropdown Script -->
    <script>
        // Enable hover dropdown for desktop, keep click for mobile
        document.addEventListener('DOMContentLoaded', function () {
            const dropdowns = document.querySelectorAll('.navbar-custom .nav-item.dropdown');

            dropdowns.forEach(function (dropdown) {
                const dropdownToggle = dropdown.querySelector('.dropdown-toggle');
                const dropdownMenu = dropdown.querySelector('.dropdown-menu');

                // For desktop: show on hover
                if (window.innerWidth > 992) {
                    dropdown.addEventListener('mouseenter', function () {
                        dropdownMenu.classList.add('show');
                    });

                    dropdown.addEventListener('mouseleave', function () {
                        dropdownMenu.classList.remove('show');
                    });

                    // Prevent click toggle on desktop
                    dropdownToggle.addEventListener('click', function (e) {
                        e.preventDefault();
                        // Allow navigation if dropdown has href
                        if (dropdownToggle.getAttribute('href') && dropdownToggle.getAttribute('href') !== '#') {
                            window.location.href = dropdownToggle.getAttribute('href');
                        }
                    });
                }
            });
    });
    </script>

    <!-- Popup Modal Script -->
    <script src="<?php echo e(asset('js/popup-modal.js')); ?>" defer></script>

    <?php echo $__env->yieldPushContent('scripts'); ?>

    
    <?php
        $popup = \App\Models\Popup::getActivePopup(request()->is('/') ? 'homepage' : 'all_pages');
    ?>
    <?php if (isset($component)) { $__componentOriginal4044772531b4d8b8af032160fd624fd0 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal4044772531b4d8b8af032160fd624fd0 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.popup-modal','data' => ['popup' => $popup]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('popup-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['popup' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($popup)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal4044772531b4d8b8af032160fd624fd0)): ?>
<?php $attributes = $__attributesOriginal4044772531b4d8b8af032160fd624fd0; ?>
<?php unset($__attributesOriginal4044772531b4d8b8af032160fd624fd0); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal4044772531b4d8b8af032160fd624fd0)): ?>
<?php $component = $__componentOriginal4044772531b4d8b8af032160fd624fd0; ?>
<?php unset($__componentOriginal4044772531b4d8b8af032160fd624fd0); ?>
<?php endif; ?>
</body>

</html><?php /**PATH C:\laragon\www\ramu\resources\views/layouts/app.blade.php ENDPATH**/ ?>