<div class="card mb-3 shadow-sm border-0">
    <div class="card-header text-white text-center py-2" style="background-color: var(--primary-color);">
        <h6 class="mb-0 fw-bold"><?php echo e($widget->title); ?></h6>
    </div>
    <div class="card-body p-0 text-center bg-white">
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($widget->type == 'image_link'): ?>
            <a href="<?php echo e($widget->link ?? '#'); ?>" target="_blank">
                <img src="<?php echo e($widget->image_url); ?>" class="img-fluid w-100" alt="<?php echo e($widget->title); ?>">
            </a>
        <?php elseif($widget->type == 'video'): ?>
            <div class="ratio ratio-16x9">
                <iframe src="<?php echo e($widget->video_embed_url); ?>" title="<?php echo e($widget->title); ?>" allowfullscreen></iframe>
            </div>
        <?php elseif($widget->type == 'text'): ?>
            <div class="p-3">
                <?php echo $widget->content; ?>

            </div>
        <?php elseif($widget->type == 'calendar'): ?>
            <?php
                $now = \Carbon\Carbon::now();
                $currentMonth = $now->format('F Y');
                $daysInMonth = $now->daysInMonth;
                $firstDayOfWeek = $now->copy()->startOfMonth()->dayOfWeek; // 0 (Sun) - 6 (Sat)
                $today = $now->day;
            ?>
            <div class="p-3 bg-white">
                <h6 class="text-center fw-bold mb-3 border-bottom pb-2" style="color: var(--secondary-color);">
                    <?php echo e($currentMonth); ?></h6>
                <table class="table table-bordered table-sm text-center mb-0" style="font-size: 0.85rem;">
                    <!-- ... calendar table ... -->
                    <thead>
                        <tr class="bg-light">
                            <th class="text-danger">S</th>
                            <th>M</th>
                            <th>T</th>
                            <th>W</th>
                            <th>T</th>
                            <th>F</th>
                            <th>S</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <?php $cellCount = 0; ?>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php for($i = 0; $i < $firstDayOfWeek; $i++): ?>
                                <td></td>
                                <?php $cellCount++; ?>
                            <?php endfor; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php for($day = 1; $day <= $daysInMonth; $day++): ?>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($cellCount % 7 == 0 && $cellCount != 0): ?>
                                    </tr>
                                    <tr>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                                <td class="<?php echo e($day == $today ? 'text-white fw-bold' : ''); ?>"
                                    style="<?php echo e($day == $today ? 'background-color: var(--secondary-color);' : ''); ?>">
                                    <?php echo e($day); ?>

                                </td>
                                <?php $cellCount++; ?>
                            <?php endfor; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php while($cellCount % 7 != 0): ?>
                                <td></td>
                                <?php $cellCount++; ?>
                            <?php endwhile; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </tr>
                    </tbody>
                </table>
            </div>
        <?php elseif($widget->type == 'link'): ?>
            <div class="p-3">
                <a href="<?php echo e($widget->link); ?>" target="_blank"
                    class="text-decoration-none d-flex align-items-center justify-content-start"
                    style="color: var(--primary-color);">
                    <i class="fas fa-link me-2"></i>
                    <span><?php echo e($widget->content); ?></span>
                </a>
            </div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    </div>
</div><?php /**PATH C:\laragon\www\ramu\resources\views/partials/sidebar-widget.blade.php ENDPATH**/ ?>