
<?php
    // Use theme CSS variables instead of settings array
    $borderRadius = $settings['sidebar_border_radius'] ?? '10px';
    $borderWidth = $settings['sidebar_border_width'] ?? '3px';

    $imageWidth = $settings['sidebar_image_width'] ?? '100%';

    $aspectRatio = $settings['sidebar_aspect_ratio'] ?? '3/4';
    $imageHeight = ($aspectRatio === 'custom') ? ($settings['sidebar_image_height'] ?? 'auto') : 'auto';
    $styleAspectRatio = ($aspectRatio !== 'custom' && $aspectRatio !== 'auto') ? $aspectRatio : 'auto';

    $imagePosition = $settings['sidebar_image_position'] ?? 'top center';
    $imageFit = $settings['sidebar_image_fit'] ?? 'cover';

    $titleFontSize = $settings['sidebar_title_font_size'] ?? '1.1rem';
    $desigFontSize = $settings['sidebar_desig_font_size'] ?? '0.875rem';
    $cardPadding = $settings['sidebar_card_padding'] ?? '1rem';
?>

<div class="card mb-3 shadow-sm border-0">
    <div class="card-header py-2 text-center" style="background-color: var(--primary-color); color: white;">
        <h6 class="mb-0 fw-bold"><?php echo e($title); ?></h6>
    </div>
    <div class="card-body text-center"
        style="background-color: var(--header-bg-color); color: white; padding: <?php echo e($cardPadding); ?> !important;">
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($message->image_url): ?>
            <div class="message-card-img-container mb-3">
                <img src="<?php echo e($message->image_url); ?>" alt="<?php echo e($message->name); ?>" class="message-card-img"
                    referrerpolicy="no-referrer">
            </div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        <h6 class="mb-1 fw-bold" style="color: var(--accent-color); font-size: <?php echo e($titleFontSize); ?>;">
            <?php echo e($message->name); ?>

        </h6>
        <small class="d-block mb-3"
            style="color: white; font-size: <?php echo e($desigFontSize); ?>;"><?php echo e($message->designation); ?></small>
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($message->slug): ?>
            <a href="<?php echo e(route('message.show', $message->slug)); ?>" class="btn btn-sm rounded-pill px-4 fw-bold"
                style="background-color: var(--secondary-color); color: white; border: none;">Read Message</a>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    </div>
</div><?php /**PATH C:\laragon\www\ramu\resources\views/partials/sidebar-message-cards/solid.blade.php ENDPATH**/ ?>