
<?php
    // Use Google Drive URL for background image
    $gdriveUrl = $settings['message_card_bg_image_gdrive'] ?? null;

    // Convert Google Drive URL to direct image URL if needed
    if ($gdriveUrl) {
        // Extract file ID from various Google Drive URL formats
        if (preg_match('/\/file\/d\/([a-zA-Z0-9_-]+)/', $gdriveUrl, $matches)) {
            // Format: https://drive.google.com/file/d/FILE_ID/view
            $fileId = $matches[1];
            $gdriveUrl = "https://drive.google.com/thumbnail?id={$fileId}&sz=w1920";
        } elseif (preg_match('/[?&]id=([a-zA-Z0-9_-]+)/', $gdriveUrl, $matches)) {
            // Already in correct format or has id parameter
            $fileId = $matches[1];
            $gdriveUrl = "https://drive.google.com/thumbnail?id={$fileId}&sz=w1920";
        }
    }

    $bgStyle = $gdriveUrl
        ? "background: url('{$gdriveUrl}') center/cover;"
        : "background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));";
?>

<div class="card mb-3 shadow-lg border-0" style="overflow: hidden;">
    <div class="card-header py-2 text-center"
        style="background-color: var(--primary-color); color: white; border-bottom: 2px solid var(--accent-color);">
        <h6 class="mb-0 fw-bold"><?php echo e($title); ?></h6>
    </div>
    <div class="card-body text-center position-relative"
        style="<?php echo e($bgStyle); ?> color: white; padding: 1.5rem !important;">
        
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($message->image_url): ?>
            <div class="message-card-img-container mb-3">
                <img src="<?php echo e($message->image_url); ?>" alt="<?php echo e($message->name); ?>" class="message-card-img"
                    referrerpolicy="no-referrer">
            </div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        <h6 class="mb-1 fw-bold"
            style="color: var(--accent-color); font-size: 1.1rem; text-shadow: 2px 2px 4px rgba(0,0,0,0.5);">
            <?php echo e($message->name); ?>

        </h6>
        <small class="d-block mb-3"
            style="color: #f0f0f0; font-size: 0.875rem; text-shadow: 1px 1px 2px rgba(0,0,0,0.5);"><?php echo e($message->designation); ?></small>
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($message->slug): ?>
            <a href="<?php echo e(route('message.show', $message->slug)); ?>" class="btn btn-sm rounded-pill px-4 fw-bold"
                style="background-color: var(--secondary-color); color: white; border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.3);">Read
                Message</a>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    </div>
</div><?php /**PATH C:\laragon\www\ramu\resources\views/partials/sidebar-message-cards/image.blade.php ENDPATH**/ ?>